/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.block.TemporaryBlock;
import com.hollingsworth.arsnouveau.common.block.tile.TemporaryTile;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.world.saved_data.RedstoneSavedData;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;

public class EffectRedstone
extends AbstractEffect {
    public static EffectRedstone INSTANCE = new EffectRedstone();
    public ModConfigSpec.IntValue BONUS_TIME;

    private EffectRedstone() {
        super(GlyphLib.EffectRedstoneID, "Redstone Signal");
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        int signalModifier = Mth.clamp((int)((int)spellStats.getAmpMultiplier() + 10), (int)1, (int)15);
        int timeBonus = (int)spellStats.getDurationMultiplier();
        int delay = Math.max((Integer)this.GENERIC_INT.get() + timeBonus * (Integer)this.BONUS_TIME.get(), 2);
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, rayTraceResult.getBlockPos(), rayTraceResult, spellStats);
        Player fakePlayer = ANFakePlayer.getOrFakePlayer((ServerLevel)world, shooter);
        for (BlockPos pos1 : posList) {
            BlockEvent.EntityPlaceEvent event;
            if (spellStats.isSensitive()) {
                if (!world.isInWorldBounds(pos1)) {
                    return;
                }
                pos1 = pos1.immutable();
                RedstoneSavedData.from((ServerLevel)((ServerLevel)world)).SIGNAL_MAP.put(pos1, new RedstoneSavedData.Entry(pos1, signalModifier, delay));
                world.neighborChanged(pos1, world.getBlockState(pos1).getBlock(), pos1);
                world.updateNeighborsAt(pos1, world.getBlockState(pos1).getBlock());
                continue;
            }
            if (!world.isInWorldBounds(pos1 = pos1.relative(rayTraceResult.getDirection()))) {
                return;
            }
            boolean notReplaceable = !world.getBlockState(pos1).canBeReplaced();
            if (notReplaceable || (event = (BlockEvent.EntityPlaceEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)pos1), world.getBlockState(pos1), (Entity)fakePlayer))).isCanceled()) continue;
            BlockState state1 = (BlockState)((TemporaryBlock)BlockRegistry.TEMPORARY_BLOCK.get()).defaultBlockState().setValue((Property)TemporaryBlock.POWER, (Comparable)Integer.valueOf(signalModifier));
            world.setBlockAndUpdate(pos1, state1);
            BlockEntity blockEntity = world.getBlockEntity(pos1);
            if (blockEntity instanceof TemporaryTile) {
                TemporaryTile tile = (TemporaryTile)blockEntity;
                tile.gameTime = world.getGameTime();
                tile.tickDuration = delay;
                tile.mimicState = Blocks.REDSTONE_BLOCK.defaultBlockState();
                tile.updateBlock();
            }
            world.sendBlockUpdated(pos1, world.getBlockState(pos1), world.getBlockState(pos1), 2);
        }
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericInt(builder, 5, "Base time in ticks", "base_duration");
        this.BONUS_TIME = builder.comment("Extend time bonus, in ticks").defineInRange("extend_time", 10, 0, Integer.MAX_VALUE);
    }

    @Override
    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        super.addDefaultAugmentLimits(defaults);
        defaults.put(AugmentSensitive.INSTANCE.getRegistryName(), 1);
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentAOE.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentSensitive.INSTANCE);
    }

    @Override
    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        this.addBlockAoeAugmentDescriptions(map);
        map.put(AugmentAmplify.INSTANCE, "Increases the power of the redstone signal.");
        map.put(AugmentDampen.INSTANCE, "Decreases the power of the redstone signal.");
        map.put(AugmentSensitive.INSTANCE, "Sets the target block to a redstone power source, powering itself and its neighbors.");
        map.put(AugmentExtendTime.INSTANCE, "Increases the duration of the redstone signal.");
        map.put(AugmentDurationDown.INSTANCE, "Decreases the duration of the redstone signal.");
    }

    @Override
    public String getBookDescription() {
        return "Places a temporary block of redstone with configurable power and duration. Augment with Sensitive to set the target block as a power source for itself and surrounding blocks. Dampen and Amplify will adjust the power from the base value of 10.";
    }

    @Override
    public int getDefaultManaCost() {
        return 0;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

